from mail.devpack.lib.components.postgres import Postgres


class SherlockDb(Postgres):
    NAME = "sherlockdb"

    before_all_prefixes = [
        'resfs/file/mail/pg/sherlockdb/drop',
        'resfs/file/mail/pg/sherlockdb/constants',
    ]
    after_all_prefixes = [
        'resfs/file/mail/pg/sherlockdb/code',
        'resfs/file/mail/pg/sherlockdb/grants',
    ]
    migration_prefixes = [
        'resfs/file/mail/pg/sherlockdb/migrations',
    ]
    snapshot_sql_files = [
        'resfs/file/mail/pg/sherlockdb/sherlockdb.sql',
    ]

    def __init__(self, env, _):
        users = ['sherlock', 'watson']
        self.init_from_conf(env.get_config(), self.NAME, users)

    # Sherlockdb-related queries

    def cleanup(self):
        for table in ['sherlock.templates', 'sherlock.template_bodies', 'sherlock.detemples']:
            self.execute('DELETE FROM {table}'.format(table=table))

    def add_template_body(self, stable_sign, sign, chunks=None):
        INSERT_QUERY = '''
            INSERT INTO sherlock.template_bodies (stable_sign, sign, chunks)
            VALUES (%(stable_sign)s, %(sign)s, %(chunks)s)'''
        self.execute(INSERT_QUERY, stable_sign=stable_sign, sign=sign, chunks=chunks)
