import requests

from .base import BaseComponent
from .tvmtool import TvmTool


class TvmClient(BaseComponent):
    NAME = "tvm_client"
    DEPS = [TvmTool]

    @staticmethod
    def gen_config(port_generator, config=None):
        return {
            "tvm": {
                "client_id": next(port_generator),  # Why not?
            }
        }

    def __init__(self, env, components):
        super(TvmClient, self).__init__(env, components)
        self._client_id = self.config[self.name]['tvm']['client_id']
        self.tvmtool = components[TvmTool]

    def signed_req(self, url, dst_client_id, method='get', timeout=10, **kwargs):
        headers = kwargs.pop('headers', {})
        headers['X-Ya-Service-Ticket'] = self.tvmtool.get_ticket(src=self._client_id, dst=dst_client_id)
        return requests.request(
            method,
            url,
            headers=headers,
            timeout=timeout,
            **kwargs
        )

    def start(self):
        pass

    def stop(self):
        pass

    def info(self):
        return {
            "state": self.state,
            "root": self.root,
            "client_id": self._client_id,
        }
