from collections import deque

from toposort import toposort_flatten


def components(top_comp_cls):
    component_classes = set()
    q = deque([top_comp_cls])
    while q:
        curr_cls = q.pop()
        component_classes.add(curr_cls)
        for dep in curr_cls.DEPS:
            q.appendleft(dep)
    return list(component_classes)


def toposorted(top_comp_cls):
    graph = {c: set(c.DEPS) for c in components(top_comp_cls)}
    return toposort_flatten(graph, sort=False)


def find(name, top_comp_cls):
    try:
        return next(c for c in components(top_comp_cls) if c.NAME == name)
    except StopIteration:
        raise KeyError('no component with name %s' % name)


def names(top_comp_cls):
    return sorted([c.NAME for c in components(top_comp_cls)])
