import logging


log = logging.getLogger(__name__)


class DbComponentMixin(object):
    @property
    def before_all_prefixes(self):
        return []

    @property
    def after_all_prefixes(self):
        return []

    @property
    def migration_prefixes(self):
        return []

    @property
    def snapshot_sql_files(self):
        return []


def if_server_not_start(function):
    def wrapper(self, *args, **kwargs):
        if self._check_run_server():
            self.logger.info('server %s already starting', self.server_name)
        else:
            function(self, *args, **kwargs)

    return wrapper


def if_server_start(function):
    def wrapper(self, *args, **kwargs):
        if not self._check_run_server():
            self.logger.info('server %s not starting', self.server_name)
        else:
            function(self, *args, **kwargs)

    return wrapper
