import os
import subprocess

from mail.devpack.lib.errors import DevpackError


class DevEnv(object):
    def __init__(self, config):
        self.config = config

    def get_config(self):
        return self.config

    def get_arcadia_bin(self, path):
        arcadia_root = self.config["arcadia"]
        bin_path = os.path.join(arcadia_root, *path.split('/'))
        if not os.path.exists(bin_path):
            raise DevpackError('Binary at %s not found. Please build it.' % bin_path)
        return bin_path

    def log_stdout(self):
        return True

    def get_java_path(self):
        arcadia_root = self.config["arcadia"]
        ya_path = os.path.join(arcadia_root, "ya")
        ya_path = os.path.expanduser(ya_path)
        cmd = [ya_path, "tool", "java", "--print-path"]
        return subprocess.check_output(cmd).strip()
