from yatest.common import binary_path, runtime
from mail.devpack.lib.config_master import generate_config

from mail.devpack.lib.coordinator import Coordinator
from yatest.common import network


class RecipeEnv(object):
    def __init__(self, config):
        self.config = config

    def get_config(self):
        return self.config

    def get_arcadia_bin(self, path):
        return binary_path(path)

    def log_stdout(self):
        return False

    def get_java_path(self):
        return runtime.java_path()


def get_cfg(top_comp_cls):
    pm = network.PortManager()
    return generate_config(lambda port: pm.get_port(port), 'devpack',
                           top_comp_cls=top_comp_cls)


def get_coordinator(cfg, component_cls):
    env = RecipeEnv(cfg)
    return Coordinator(env, top_comp_cls=component_cls)
