import os
import json
from . import helpers


INIT_STATE = {
    'root_inited': False,
    'started': False,
    'data_prepared': False
}


def get_state_path(config, component_name):
    wd = config.root
    state_file = os.path.join(wd, config['sysdata']['state_dir'], component_name + ".json")
    return os.path.expanduser(state_file)


def read_state(config, component_name):
    state_file = get_state_path(config, component_name)
    if os.path.isfile(state_file):
        return json.load(open(state_file))
    else:
        return INIT_STATE.copy()


def write_state(config, component_name, state):
    state_json = json.dumps(state)
    state_dir = os.path.join(config.root, config['sysdata']['state_dir'])
    helpers.mkdir_recursive(state_dir)
    state_file = os.path.join(state_dir, component_name + '.json')
    helpers.write2file(state_json, state_file)
