PY23_LIBRARY()

OWNER(
    g:mail
)

PY_SRCS(
    ch.py
    components_manager.py
    config_master.py
    coordinator.py
    db.py
    errors.py
    env.py
    helpers.py
    pg.py
    state.py
    recipe.py
    yhttp_service.py
    yhttp_app_service.py

    components/all_dumb.py
    components/base.py
    components/calendardb.py
    components/clickhouse.py
    components/emptydb.py
    components/fakebb.py
    components/fbbdb.py
    components/mdb.py
    components/mulcagate.py
    components/pyremock.py
    components/sharddb.py
    components/sharpei.py
    components/cloud_cluster.py
    components/sherlockdb.py
    components/postgres.py
    components/postgres_cluster.py
    components/tvm_client.py
    components/tvm_mulcagate.py
    components/tvmapi.py
    components/tvmtool.py
    components/unimock.py
    components/werkzeug_component.py
    components/sheltie.py
)

# FROM_SANDBOX(FILE 901180694 OUT_NOAUTO tool/.bin/linux/tvmtool)

FROM_SANDBOX(FILE 841004555 OUT_NOAUTO postgresql-mail-10-precise.tgz)
FROM_SANDBOX(FILE 828461967 OUT_NOAUTO postgresql-mail-10-trusty.tgz)
FROM_SANDBOX(FILE 828460167 OUT_NOAUTO postgresql-mail-10-xenial.tgz)
FROM_SANDBOX(FILE 828462406 OUT_NOAUTO postgresql-mail-10-bionic.tgz)
FROM_SANDBOX(FILE 3131084485 OUT_NOAUTO postgresql-mail-10-focal.tgz)

RESOURCE(
    # tool/.bin/linux/tvmtool tvmtool
    postgresql-mail-10-precise.tgz postgresql-precise.tgz
    postgresql-mail-10-trusty.tgz postgresql-trusty.tgz
    postgresql-mail-10-xenial.tgz postgresql-xenial.tgz
    postgresql-mail-10-bionic.tgz postgresql-bionic.tgz
    postgresql-mail-10-focal.tgz postgresql-focal.tgz
    mail/devpack/lib/config/pg.conf pg/pg.conf
    mail/devpack/lib/config/pg_hba.conf pg/pg_hba.conf
    mail/devpack/lib/config/pg_recovery.conf pg/recovery.conf

    mail/devpack/lib/config/clickhouse/config.xml   ch/config.xml
    mail/devpack/lib/config/clickhouse/users.xml    ch/users.xml
)

FROM_SANDBOX(634188483 OUT_NOAUTO mbody/recognize/dict.dict mbody/wizard/language/queryrec.dict
        mbody/wizard/language/queryrec.weights)
RESOURCE(
    mbody/recognize/dict.dict               recognizer/dict.dict
    mbody/wizard/language/queryrec.dict     recognizer/queryrec.dict
    mbody/wizard/language/queryrec.weights  recognizer/queryrec.weights
)

FROM_SANDBOX(FILE 806010524 OUT_NOAUTO attach_sid_aes_keys.json attach_sid_aes_keys.json)
RESOURCE(
    attach_sid_aes_keys.json               attach_sid_aes_keys.json
)

FROM_SANDBOX(FILE 806015476 OUT_NOAUTO attach_sid_hmac_keys.json attach_sid_hmac_keys.json)
RESOURCE(
    attach_sid_hmac_keys.json               attach_sid_hmac_keys.json
)

IF(PYTHON2)
    PEERDIR(contrib/python/enum34)
ENDIF()


PEERDIR(
    contrib/python/clickhouse-driver
    contrib/python/distro
    contrib/python/psycopg2
    contrib/python/sqlparse
    contrib/python/Werkzeug
    contrib/python/psutil
    contrib/python/requests
    contrib/python/PyYAML
    contrib/python/toposort
    contrib/python/retrying
    contrib/python/pyOpenSSL
    library/python/resource
    library/python/testing/pyremock/lib
    library/python/testing/yatest_common
    mail/python/fake_mulcagate
    mail/python/fbb
    mail/contrib/backoff
    mail/webmail_config/lib
)

INCLUDE(../sql/ya.make.inc)
INCLUDE(../data/ya.make.inc)

RESOURCE(
    mail/sharpei/etc/config-base.yml sharpei/config-base.yml
    mail/sharpei/etc/config-mail-base.yml sharpei/config-mail-base.yml
    mail/sharpei/tests/integration/cloud/enviroment/jwt sharpei/jwt
    mail/devpack/lib/config/sharpei/config-devpack-mail.yml sharpei/config-devpack-mail.yml
    mail/devpack/lib/config/sharpei/config-devpack-disk.yml sharpei/config-devpack-disk.yml
    mail/devpack/lib/config/sharpei/config-devpack-datasync.yml sharpei/config-devpack-datasync.yml
    mail/devpack/lib/config/sharpei/config-devpack-cloud.yml sharpei/config-devpack-cloud.yml
    mail/devpack/lib/config/sharpei/tvm_secret sharpei/tvm_secret
    mail/sharpei/etc/config-disk.yml sharpei/config-disk.yml
    mail/sharpei/etc/config-datasync.yml sharpei/config-datasync.yml
    mail/sharpei/etc/config-cloud.yml sharpei/config-cloud.yml

    mail/macs_pg/etc/query.conf macs_pg/query.conf
    mail/devpack/lib/config/pgpass macs_pg/pgpass

    mail/devpack/lib/config/mdb.yml mdb/mdb.yml

    mail/devpack/lib/config/vdirect_keys           mail_getter/vdirect_keys

    mail/webmail_config/common.yaml                webmail_config/common.yaml

    mail/content_type_detector_config/libmagic.issues content_type_detector_config/libmagic.issues
    mail/content_type_detector_config/magic           content_type_detector_config/magic
    mail/content_type_detector_config/mime.types      content_type_detector_config/mime.types
    mail/content_type_detector_config/mime-types.xml  content_type_detector_config/mime-types.xml

    mail/devpack/lib/config/tvmapi/keys            tvmapi/keys
    mail/devpack/lib/config/tvmapi/service_tickets tvmapi/service_tickets

    mail/sheltie/etc/sheltie.yml        sheltie/base.yml
    mail/sheltie/etc/service.yaml       sheltie/service.yaml
    mail/sheltie/package/python/transform.py      sheltie/transform.py
    mail/devpack/lib/config/sheltie/config-devpack.yml sheltie/config-devpack.yml
    mail/devpack/lib/config/sheltie/tvm_secret sheltie/tvm_secret

    metrika/uatraits/data/browser.xml          uatraits/browser.xml
    metrika/uatraits/data/profiles.xml         uatraits/profiles.xml
)

END()

RECURSE(
    components/all
)
