import library.python.testing.recipe as recipe
import mail.devpack.lib.recipe as devpack_recipe

from mail.devpack.lib import components_manager
import yaml


class Recipe:
    def __init__(self, top_comp_cls):
        self.__top_comp_cls = top_comp_cls

    def declare(self):
        recipe.declare_recipe(self.__start, self.__stop)

    def __start(self, argv):
        cfg = devpack_recipe.get_cfg(top_comp_cls=self.__top_comp_cls)
        with open('devpack-config.yaml', 'w') as f:
            f.write(yaml.dump(cfg))

        for service in argv:
            comp_cls = components_manager.find(service, top_comp_cls=self.__top_comp_cls)
            devpack_recipe.get_coordinator(cfg, comp_cls).start()

    def __stop(self, argv):
        with open('devpack-config.yaml') as f:
            cfg = yaml.load(f.read(), yaml.Loader)

        for service in argv:
            comp_cls = components_manager.find(service, top_comp_cls=self.__top_comp_cls)
            devpack_recipe.get_coordinator(cfg, comp_cls).stop()


def declare_recipe(top_comp_cls):
    Recipe(top_comp_cls).declare()


def get_coordinator(top_comp_cls):
    with open('devpack-config.yaml') as f:
        cfg = yaml.load(f.read(), yaml.Loader)
        return devpack_recipe.get_coordinator(cfg, top_comp_cls)
