#! /usr/bin/env bash

# use this script to upload new tgz-archive with clickhouse to sandbox
# SOURCE: https://clickhouse.com/docs/ru/getting-started/install/#install-from-deb-packages

set -x

command -v ya >/dev/null 2>&1 || { echo >&2 '"ya" command not found. Please add it to your $PATH.'; exit 1; }

sudo sh -c 'echo "
deb https://packages.clickhouse.com/deb lts main
" > /etc/apt/sources.list.d/devpack.list'

sudo apt-get update

CWD=$(pwd)
ROOT=$(mktemp -d)
ARCHIVE_ROOT=$ROOT/ch
CH_VER=22.3.7.28
TGZ=clickhouse-mail-$CH_VER.tgz

cd $ROOT
apt-get download --allow-unauthenticated \
    clickhouse-server=$CH_VER \
    clickhouse-common-static=$CH_VER \
|| exit



for deb in *.deb; do
    dpkg -x $deb $ARCHIVE_ROOT
    echo $deb
done

cd $ARCHIVE_ROOT
tar -czvf $TGZ *

ya upload $TGZ \
    --ttl=inf \
    --arch=linux \
    --do-not-remove \
    --owner=MAIL \
    -T=MAIL_CLICKHOUSE \
    -d="ClickHouse for Ya.Mail" \
    -A="major_version=$CH_VER"

cd $CWD
echo "ARCHIVE_ROOT=$ARCHIVE_ROOT"
