#! /usr/bin/env bash

# use this script to upload new tgz-archive with postgresql to sandbox

set -x

command -v ya >/dev/null 2>&1 || { echo >&2 '"ya" command not found. Please add it to your $PATH.'; exit 1; }

sudo sh -c 'echo "
deb http://apt.postgresql.org/pub/repos/apt/ $(lsb_release -cs)-pgdg main
deb http://dist.yandex.ru/yandex-postgresql stable/all/
deb http://dist.yandex.ru/yandex-postgresql stable/\$(ARCH)/
deb http://dist.yandex.ru/mail-trusty stable/all/
deb http://dist.yandex.ru/mail-trusty stable/\$(ARCH)/
" > /etc/apt/sources.list.d/devpack.list'
wget --quiet -O - https://www.postgresql.org/media/keys/ACCC4CF8.asc | sudo apt-key add -
sudo apt-get update

CWD=$(pwd)
ROOT=$(mktemp -d)
ARCHIVE_ROOT=$ROOT/pg
PG_VER=10
UBUNTU_VER=$(lsb_release -cs)
TGZ=postgresql-mail-$PG_VER-$UBUNTU_VER.tgz

cd $ROOT
apt-get download --allow-unauthenticated \
    libpq5 \
    postgresql-$PG_VER \
    postgresql-$PG_VER-partman \
    libxxhash0 \
    postgresql-$PG_VER-pgxxhash \
    postgresql-$PG_VER-smlar \
    postgresql-client-$PG_VER \
|| exit

if [ $PG_VER -lt 10 ]; then
    apt-get download --allow-unauthenticated \
        postgresql-contrib-$PG_VER \
    || exit
fi

for deb in *.deb; do
    dpkg -x $deb $ARCHIVE_ROOT
    echo $deb
done

cd $ARCHIVE_ROOT/usr/lib
ln -sf libxxhash.so.0.42.0 libxxhash.so.0
cd $ARCHIVE_ROOT
tar -czvf $TGZ *

ya upload $TGZ \
    --ttl=inf \
    --arch=linux \
    --do-not-remove \
    --owner=MAIL \
    -T=MAIL_POSTGRESQL \
    -d="Postgresql with extensions for Ya.Mail" \
    -A="major_version=$PG_VER"

cd $CWD
echo "ARCHIVE_ROOT=$ARCHIVE_ROOT"
