#!/usr/bin/python3
# -*- coding: UTF-8 -*-

import json
import psycopg2
from bottle import route, run, request, redirect, template

db_config_file = '/app/config/db.json'

template_main = '/app/dkim-export/main.tpl'
template_corp_domain = '/app/dkim-export/corp-domain.tpl'
template_dkim_help = '/app/dkim-export/get-public-dkim.help'

get_dkim_by_domain_sql = """select coalesce(new_public_key, public_key) from dkim where domain = %(domain)s;"""


def get_conn(db_config):
    return psycopg2.connect(host=db_config['host'],
                            port=db_config['port'],
                            user=db_config['user'],
                            password=db_config['password'],
                            database=db_config['dbname'],
                            connect_timeout=3,
                            sslmode='require')


def get_public_dkim(domain):
    with get_conn(db_config) as dbconn:
        with dbconn.cursor() as cursor:
            cursor.execute(get_dkim_by_domain_sql, {'domain': domain})

            data = cursor.fetchall()
            if data:
                dkim_key = data[0][0]
                dkim_data = 'mail._domainkey.{domain}.    600    IN TXT "v=DKIM1; k=rsa; t=s; p={dkim_key}"'.format(domain=domain,
                                                                                                         dkim_key=dkim_key)
                return {'data': dkim_data, 'key': dkim_key}
            else:
                return {}

with open(db_config_file) as f:
    db_config = json.loads(f.read())

@route('/add-corp-domain')
def root():
    domain = request.GET.get('domain', 'domain')
    dkim_data = None
    if domain != 'domain':
        dkim_data = get_public_dkim(domain).get('data', 'unknown')
    return template(template_corp_domain, dkim_data=dkim_data, domain=domain, debug=True)


@route('/info')
@route('/')
def root():
    domain = request.GET.get('domain', 'domain')
    dkim_data = None
    if domain != 'domain':
        dkim_data = get_public_dkim(domain).get('data', 'unknown')
    return template(template_main, dkim_data=dkim_data, domain=domain)


@route('/api/get-public-dkim')
def api():
    domain = request.GET.get('domain', None)
    if domain:
        return getPublicDKIM(domain).get('key', 'unknown')
    else:
        return template(template_dkim_help)

@route('/api/')
def api_info():
    return template(template_dkim_help)
run(host='localhost', port=8080, debug=True)
