#ifndef DOBERMAN_SRC_CORO_CHANGE_QUEUE_ACCESS_H_
#define DOBERMAN_SRC_CORO_CHANGE_QUEUE_ACCESS_H_

#include <boost/asio/spawn.hpp>
#include <src/logic/change_queue.h>

namespace doberman {
namespace access {

template <typename Impl>
class ChangeQueue {
public:
    ChangeQueue(Impl impl, boost::asio::yield_context yield)
    : impl(impl), yield(yield) {}

    auto makeContext(const SubscriptionId& id) const {
        return detail::dereference(impl).makeContext(id);
    }

    template <typename Ctx>
    auto top(Ctx&& ctx) const {
        return detail::dereference(impl).top(std::forward<Ctx>(ctx), yield);
    }

    template <typename Ctx>
    void pop(Ctx&& ctx) const {
        detail::dereference(impl).pop(std::forward<Ctx>(ctx), yield);
    }
private:
    Impl impl;
    boost::asio::yield_context yield;
};

template <typename Impl>
inline auto makeChangeQueue(Impl impl, boost::asio::yield_context yield) {
    return ChangeQueue<Impl>(std::move(impl), std::move(yield));
}

} // namespace access
} // namespace doberman

#endif /* DOBERMAN_SRC_CORO_CHANGE_QUEUE_ACCESS_H_ */
