#pragma once

#include <src/detail/dereference.h>
#include <boost/asio/spawn.hpp>

namespace doberman {
namespace access {

template <typename Impl>
struct EnvelopeCopier {
    Impl impl;
    boost::asio::yield_context yield;

    template <typename ... Args>
    void operator()(Args&& ... args) const {
        detail::dereference(impl)(std::forward<Args>(args)..., yield);
    }
};

template <typename Impl>
auto makeEnvelopeCopier(Impl impl, boost::asio::yield_context yield) {
    return EnvelopeCopier<Impl>{impl, yield};
}

} // namespace access
} // namespace doberman
