#ifndef DOBERMAN_SRC_CORO_ACCESS_FACTORY_H_
#define DOBERMAN_SRC_CORO_ACCESS_FACTORY_H_

#include <src/access/change_queue.h>
#include <src/access/shared_folder.h>
#include <src/access/subscribed_folder.h>
#include <src/access/subscription.h>
#include <src/access/subscription_repository.h>
#include <src/access/envelope_copier.h>

namespace doberman {
namespace access {

/**
 * Data access factory specification.
 * This class implements coroutine context binding with data access interfaces'
 * implementation.
 */
template <typename Impl>
class AccessFactory {
public:
    class Access {
        Impl impl;
        boost::asio::yield_context yield;
    public:
        Access(Impl impl, boost::asio::yield_context yield)
        : impl(std::move(impl)), yield(std::move(yield)) {}

        auto sharedFolder() const {
            return makeSharedFolder(detail::dereference(impl).sharedFolder(), yield);
        }
        auto subscribedFolder() const {
            return makeSubscribedFolder(detail::dereference(impl).subscribedFolder(), yield);
        }
        auto changeQueue() const {
            return makeChangeQueue(detail::dereference(impl).changeQueue(), yield);
        }
        auto subscription() const {
            return makeSubscription(detail::dereference(impl).subscription(), yield);
        }
        auto subscriptionRepository() const {
            return makeSubscriptionRepository(
                    detail::dereference(impl).subscriptionRepository(), yield);
        }
        auto envelopeCopier() const {
            return makeEnvelopeCopier(
                    detail::dereference(impl).envelopeCopier(), yield);
        }
    };

    Access operator() (boost::asio::yield_context yield) const {
        return Access{impl, std::move(yield)};
    }

    AccessFactory(Impl impl) : impl(impl) {}
private:
    Impl impl;
};

template <typename Impl>
inline auto makeAccessFactory(Impl impl) {
    return AccessFactory<Impl>(std::move(impl));
}

} // namespace access
} // namespace doberman

#endif /* DOBERMAN_SRC_CORO_ACCESS_FACTORY_H_ */
