#pragma once

#include <boost/asio/spawn.hpp>
#include <src/logic/job_finder.h>

namespace doberman {
namespace access {

template <typename Impl>
class JobFinder {
public:
    JobFinder(Impl impl, boost::asio::yield_context yield)
    : impl(std::move(impl)), yield(yield)
    {}

    auto makeContext() const {
        return detail::dereference(impl).makeContext();
    }

    template <typename ... Args>
    auto askForJob(Args&& ... args) const {
        return detail::dereference(impl).askForJob(std::forward<Args>(args)..., yield);
    }

    template <typename ... Args>
    auto getShards(Args&& ... args) const {
        return detail::dereference(impl).getShards(std::forward<Args>(args)..., yield);
    }

private:
    Impl impl;
    boost::asio::yield_context yield;
};


template <typename Impl>
inline auto makeJobFinder(Impl impl, boost::asio::yield_context yield) {
    return JobFinder<Impl>{std::move(impl), std::move(yield)};
}

} // namespace access
} // namespace doberman
