#ifndef DOBERMAN_SRC_CORO_SHARED_FOLDER_ACCESS_H_
#define DOBERMAN_SRC_CORO_SHARED_FOLDER_ACCESS_H_

#include <boost/asio/spawn.hpp>
#include <src/logic/shared_folder.h>

namespace doberman {
namespace access {

template <typename Impl>
class SharedFolder {
public:
    using Coordinates = ::doberman::logic::SharedFolderCoordinates;
    SharedFolder(Impl impl, boost::asio::yield_context yield)
    : impl(impl), yield(yield) {}

    auto makeContext(const Coordinates& c) const {
        return detail::dereference(impl).makeContext(c);
    }

    template <typename Ctx>
    Revision revision(Ctx&& ctx) const {
        return detail::dereference(impl).revision(std::forward<Ctx>(ctx), yield);
    }

    template <typename Ctx>
    auto envelopesWithMimes(Ctx&& ctx, int64_t lowestImapId) const {
        return detail::dereference(impl).envelopesWithMimes(
                std::forward<Ctx>(ctx), lowestImapId, yield);
    }

    template <typename Ctx>
    auto labels(Ctx&& ctx) const {
        return detail::dereference(impl).labels(std::forward<Ctx>(ctx), yield);
    }
private:
    Impl impl;
    boost::asio::yield_context yield;
};

template <typename Impl>
inline auto makeSharedFolder(Impl impl, boost::asio::yield_context yield) {
    return SharedFolder<Impl>(std::move(impl), std::move(yield));
}

} // namespace access
} // namespace doberman


#endif /* DOBERMAN_SRC_CORO_SHARED_FOLDER_ACCESS_H_ */
