#ifndef DOBERMAN_SRC_CORO_SUBSCRIBED_FOLDER_ACCESS_H_
#define DOBERMAN_SRC_CORO_SUBSCRIBED_FOLDER_ACCESS_H_

#include <boost/asio/spawn.hpp>
#include <src/logic/subscribed_folder.h>

namespace doberman {
namespace access {

template <typename Impl>
class SubscribedFolder {
public:
    using Coord = ::doberman::logic::SharedFolderCoordinates;
    using MsgCoord = ::doberman::logic::MessageCoordinates;

    SubscribedFolder(Impl impl, boost::asio::yield_context yield)
    : impl(impl), yield(yield) {}

    auto makeContext(const Uid& uid) const {
        return detail::dereference(impl).makeContext(uid);
    }

    template <typename Ctx>
    Revision revision(Ctx&& ctx, Coord c) const {
        return detail::dereference(impl).revision(std::forward<Ctx>(ctx), std::move(c), yield);
    }

    template <typename Ctx>
    void put(Ctx&& ctx, Coord c, EnvelopeWithMimes e) const {
        detail::dereference(impl).put(std::forward<Ctx>(ctx), std::move(c), std::move(e), yield);
    }

    template <typename Ctx>
    void initPut(Ctx&& ctx, Coord c, EnvelopeWithMimes e) const {
        detail::dereference(impl).initPut(std::forward<Ctx>(ctx), std::move(c), std::move(e), yield);
    }

    template <typename Ctx>
    void erase(Ctx&& ctx, Coord c, macs::MidVec mids, Revision r) const {
        detail::dereference(impl).erase(std::forward<Ctx>(ctx), std::move(c), std::move(mids), std::move(r), yield);
    }

    template <typename Ctx>
    void mark(Ctx&& ctx, MsgCoord m, std::vector<Label> labels, Revision r) const {
        detail::dereference(impl).mark(std::forward<Ctx>(ctx), std::move(m), std::move(labels), std::move(r), yield);
    }

    template <typename Ctx>
    void unmark(Ctx&& ctx, MsgCoord m, std::vector<Label> labels, Revision r) const {
        detail::dereference(impl).unmark(std::forward<Ctx>(ctx), std::move(m), std::move(labels), std::move(r), yield);
    }

    template <typename Ctx>
    void joinThreads(Ctx&& ctx, Coord c, ThreadId tid, std::vector<ThreadId> joinTids, Revision r) const {
        detail::dereference(impl).joinThreads(std::forward<Ctx>(ctx), std::move(c), std::move(tid), std::move(joinTids),
                                              std::move(r), yield);
    }

    template <typename Ctx>
    auto envelopes(Ctx&& ctx, Coord c) const {
        return detail::dereference(impl).envelopes(std::forward<Ctx>(ctx), std::move(c), yield);
    }

    template <typename Ctx>
    LabelSet labels(Ctx&& ctx) const {
        return detail::dereference(impl).labels(std::forward<Ctx>(ctx), yield);
    }

    template <typename Ctx>
    Label createLabel(Ctx&& ctx, Label label) const {
        return detail::dereference(impl).createLabel(std::forward<Ctx>(ctx), std::move(label), yield);
    }

    template <typename Ctx>
    void clear(Ctx&& ctx, Coord c) const {
        detail::dereference(impl).clear(std::forward<Ctx>(ctx), std::move(c), yield);
    }

    template <typename Ctx>
    int64_t lastSyncedImapId(Ctx&& ctx, Coord c) const {
        return detail::dereference(impl).lastSyncedImapId(
            std::forward<Ctx>(ctx), std::move(c), yield);
    }
private:
    Impl impl;
    boost::asio::yield_context yield;
};

template <typename Impl>
inline auto makeSubscribedFolder(Impl impl, boost::asio::yield_context yield) {
    return SubscribedFolder<Impl>(std::move(impl), std::move(yield));
}

} // namespace access
} // namespace doberman

#endif /* DOBERMAN_SRC_CORO_SUBSCRIBED_FOLDER_ACCESS_H_ */
