#ifndef DOBERMAN_SRC_CORO_SUBSCRIPTION_ACCESS_H_
#define DOBERMAN_SRC_CORO_SUBSCRIPTION_ACCESS_H_

#include <boost/asio/spawn.hpp>
#include <src/logic/subscription.h>

namespace doberman {
namespace access {

template <typename Impl>
class Subscription {
public:
    using State = ::doberman::SubscriptionState;

    Subscription(Impl impl, boost::asio::yield_context yield)
    : impl(impl), yield(yield) {}

    template <typename ... Args>
    auto makeContext(Args&& ... args) const {
        return detail::dereference(impl).makeContext(std::forward<Args>(args)...);
    }

    template <typename Ctx>
    State state(Ctx&& ctx) const {
        return detail::dereference(impl).state(std::forward<Ctx>(ctx), yield);
    }

    template <typename Ctx>
    auto init(Ctx&& ctx) const {
        return detail::dereference(impl).init(std::forward<Ctx>(ctx), yield);
    }

    template <typename Ctx>
    State sync(Ctx&& ctx) const {
        return detail::dereference(impl).sync(std::forward<Ctx>(ctx), yield);
    }

    template <typename Ctx>
    State fail(Ctx&& ctx, std::string message) const {
        return detail::dereference(impl).fail(std::forward<Ctx>(ctx), std::move(message), yield);
    }

    template <typename Ctx>
    State finish(Ctx&& ctx) const {
        return detail::dereference(impl).finish(std::forward<Ctx>(ctx), yield);
    }

    template <typename Ctx>
    auto clear(Ctx&& ctx) const {
        return detail::dereference(impl).clear(std::forward<Ctx>(ctx), yield);
    }

private:
    Impl impl;
    boost::asio::yield_context yield;
};

template <typename Impl>
inline auto makeSubscription(Impl impl, boost::asio::yield_context yield) {
    return Subscription<Impl>(std::move(impl), std::move(yield));
}

} // namespace access
} // namespace doberman

#endif /* DOBERMAN_SRC_CORO_SUBSCRIPTION_ACCESS_H_ */
