#pragma once

#include <src/access_impl/retry.h>
#include <src/logic/agent.h>

namespace doberman {
namespace access_impl {

template <typename Log>
struct RobustEnvelopeCopier {
    std::size_t maxTries;
    Seconds interval;
    Log log;
    logic::TrivialEnvelopeCopier copy;

    RobustEnvelopeCopier(Retries retries, Log log)
    : maxTries(retries.retries), interval(Seconds(retries.timeout_sec)),
      log(std::move(log)) {}

    template <typename T1, typename T2, typename Condition, typename Yield>
    void operator()(const logic::SharedFolder<T1>& src, logic::SubscribedFolder<T2>& dst,
                    Condition&& stopReading, Yield yield) const {
        const auto logger = [&] (auto e) {
            DOBBY_LOG_NOTICE(log, "retry envelope copying after error", log::exception=*e);
        };
        makeTemporaryErrorRetry(maxTries, interval, logger)([&](auto){ copy(src, dst, stopReading);}, yield);
    }
};

} // namespace access_impl
} // namespace doberman
