#ifndef DOBERMAN_SRC_ACCESS_IMPL_REVISION_CACHE_H_
#define DOBERMAN_SRC_ACCESS_IMPL_REVISION_CACHE_H_

#include <src/meta/types.h>
#include <src/logic/types.h>

namespace doberman {
namespace access_impl {

class RevisionCache {
    using SubscriberUid = Uid;
    using OwnerUid = Uid;
    using OwnerFid = Fid;
    using OwnerCoordinates = logic::SharedFolderCoordinates;

    using Cache = std::map<std::tuple<SubscriberUid, OwnerUid, OwnerFid>, Revision>;
public:
    boost::optional<Revision> get(const SubscriberUid& uid,
                                  const OwnerCoordinates& coords) const {
        auto found = cache_.find(std::make_tuple(uid, coords.owner.uid, coords.fid));
        return (found != cache_.end())
                ? boost::make_optional(found->second)
                : boost::none;
    }

    void set(const SubscriberUid& uid,
             const OwnerCoordinates& coords,
             Revision rev) {
        auto& found = cache_[std::make_tuple(uid, coords.owner.uid, coords.fid)];
        if (found < rev) {
            found = rev;
        }
    }

private:
    Cache cache_;
};

} // namespace access_impl
} // namespace doberman

#endif /* DOBERMAN_SRC_ACCESS_IMPL_REVISION_CACHE_H_ */
