#ifndef DOBERMAN_SRC_ACCESS_IMPL_TIMER_H_
#define DOBERMAN_SRC_ACCESS_IMPL_TIMER_H_

#include <boost/asio.hpp>
#include <boost/asio/spawn.hpp>
#include <boost/asio/steady_timer.hpp>
#include <chrono>

namespace doberman {
namespace access_impl {
namespace timer {

namespace detail {
template <typename Duration>
inline void wait(Duration&& timeout, ::boost::asio::yield_context yield) {
    using namespace boost::asio;
#if BOOST_VERSION < 106600
    auto& io = yield.handler_.dispatcher_.get_io_service();
#else
    const auto get_io_context = [&]() -> io_context& {
        decltype(auto) executor = get_associated_executor(yield.handler_);
        if (auto target = executor.target<strand<io_context::executor_type>>()) {
            return target->get_inner_executor().context();
        }
        if (auto target = executor.target<io_context::strand>()) {
            return target->context();
        }
        if (auto target = executor.target<io_context::executor_type>()) {
            return target->context();
        }
        throw std::invalid_argument("can not obtain io_context from executor");
    };
    auto& io = get_io_context();
#endif
    steady_timer timer(io);
    timer.expires_from_now(std::forward<Duration>(timeout));
    timer.async_wait(yield);
}
} // namespace detail


template <typename Duration, typename Yield>
inline void wait(Duration&& timeout, Yield&& yield) {
    using detail::wait;
    wait(std::forward<Duration>(timeout), std::forward<Yield>(yield));
}

} // namespace timer
} // namespace access_impl
} // namespace doberman

#endif /* DOBERMAN_SRC_ACCESS_IMPL_TIMER_H_ */
