#pragma once

#include <boost/preprocessor/seq.hpp>
#include <boost/preprocessor/tuple.hpp>
#include <boost/preprocessor/stringize.hpp>

#include <type_traits>

#if !BOOST_PP_VARIADICS
#error "Your compiler should support variadic macro arguments"
#endif

//============has_type===============

#define DOBBY_HAS_TYPE_STRUCT_NAME(name, uid)\
    BOOST_PP_CAT(has_type_ ## name, uid)

#define DOBBY_HAS_TYPE_AUX(name, uid)\
    template <typename T>\
    struct DOBBY_HAS_TYPE_STRUCT_NAME(name, uid) {\
        template <typename U>\
        static std::true_type check(typename U::name*);\
        \
        template <typename>\
        static std::false_type check(...);\
        \
        static constexpr bool value = decltype(check<T>(nullptr))::value;\
    };

#define DOBBY_HAS_TYPE_CHECK(name, uid)\
    DOBBY_HAS_TYPE_STRUCT_NAME(name, uid)<Type>::value

#define DOBBY_HAS_TYPE_MESSAGE(name)\
    " needs to have nested type '" BOOST_PP_STRINGIZE(name) "'"

#define DOBBY_HAS_TYPE_IMPL(name, uid)\
    ((DOBBY_HAS_TYPE_AUX(name, uid)))\
    ((DOBBY_HAS_TYPE_CHECK(name, uid)))\
    (DOBBY_HAS_TYPE_MESSAGE(name))

#define DOBBY_HAS_TYPE(name) (DOBBY_HAS_TYPE_IMPL(name, __COUNTER__))

//============has_field================

#define DOBBY_HAS_FIELD_STRUCT_NAME(name, uid)\
    BOOST_PP_CAT(has_field_ ## name, uid)

#define DOBBY_HAS_FIELD_AUX(name, uid)\
    template <typename T, typename FieldT>\
    struct DOBBY_HAS_FIELD_STRUCT_NAME(name, uid) {\
        template <typename U>\
        static auto check(U&& obj)\
            -> decltype(std::is_same<FieldT, decltype(obj.name)>());\
        \
        static std::false_type check(...);\
        \
        static constexpr bool value = decltype(check(std::declval<T>()))::value;\
    };

#define DOBBY_HAS_FIELD_CHECK(name, uid, ...)\
    DOBBY_HAS_FIELD_STRUCT_NAME(name, uid)<Type, __VA_ARGS__>::value

#define DOBBY_HAS_FIELD_MESSAGE(name, ...)\
    " needs to have field '" BOOST_PP_STRINGIZE(name) "' of type '" #__VA_ARGS__ "'"

#define DOBBY_HAS_FIELD_IMPL(name, uid, ...)\
    ((DOBBY_HAS_FIELD_AUX(name, uid)))\
    ((DOBBY_HAS_FIELD_CHECK(name, uid, __VA_ARGS__)))\
    (DOBBY_HAS_FIELD_MESSAGE(name, __VA_ARGS__))

#define DOBBY_HAS_FIELD(name, ...)\
    (DOBBY_HAS_FIELD_IMPL(name, __COUNTER__, __VA_ARGS__))

//============has_method===============

#define DOBBY_HAS_METHOD_STRUCT_NAME(name, uid)\
    BOOST_PP_CAT(has_method_ ## name, uid)

#define DOBBY_HAS_METHOD_AUX(name, uid)\
    template <typename T, typename Signature>\
    struct DOBBY_HAS_METHOD_STRUCT_NAME(name, uid);\
    \
    template <typename T, typename Ret, typename... Args>\
    struct DOBBY_HAS_METHOD_STRUCT_NAME(name, uid)<T, Ret(Args...)> {\
        template <typename U>\
        static auto check(U&& obj)\
            -> std::is_same<Ret, decltype(obj.name(std::declval<Args>()...))>;\
        \
        static std::false_type check(...);\
        \
        static constexpr bool value = decltype(check(std::declval<T>()))::value;\
    };

#define DOBBY_HAS_METHOD_CHECK(name, type, uid, ...)\
    DOBBY_HAS_METHOD_STRUCT_NAME(name, uid)<type, __VA_ARGS__>::value

#define DOBBY_HAS_METHOD_MESSAGE(name, sigSuffix, ...)\
    " needs to have method '" BOOST_PP_STRINGIZE(name) "' with signature '"\
    #__VA_ARGS__ sigSuffix "'"

#define DOBBY_HAS_METHOD_IMPL(name, type, sigSuffix, uid, ...)\
    ((DOBBY_HAS_METHOD_AUX(name, uid)))\
    ((DOBBY_HAS_METHOD_CHECK(name, type, uid, __VA_ARGS__)))\
    (DOBBY_HAS_METHOD_MESSAGE(name, sigSuffix, __VA_ARGS__))

#define DOBBY_HAS_METHOD(name, ...)\
    (DOBBY_HAS_METHOD_IMPL(name, Type, "", __COUNTER__, __VA_ARGS__))

#define DOBBY_HAS_CONST_METHOD(name, ...)\
    (DOBBY_HAS_METHOD_IMPL(name, const Type, " const", __COUNTER__, __VA_ARGS__))

//============constructible from===============

#define DOBBY_CONSTRUCTIBLE_FROM_MESSAGE(...)\
    " needs to be constructible from the following arguments list: (" #__VA_ARGS__ ")"

#define DOBBY_CONSTRUCTIBLE_FROM_IMPL(...)\
    (())\
    ((std::is_constructible<Type, __VA_ARGS__>::value))\
    (DOBBY_CONSTRUCTIBLE_FROM_MESSAGE(__VA_ARGS__))

#define DOBBY_CONSTRUCTIBLE_FROM(...) (DOBBY_CONSTRUCTIBLE_FROM_IMPL(__VA_ARGS__))

//=====================

#define DOBBY_GEN_STATIC_ASSERT(r, data, elem)\
    BOOST_PP_TUPLE_ENUM(BOOST_PP_SEQ_ELEM(0, elem))\
    static_assert(BOOST_PP_SEQ_ELEM(1, elem),\
                  "Type '" BOOST_PP_STRINGIZE(data) "'" BOOST_PP_SEQ_ELEM(2, elem));

#define DOBBY_CHECK_CONCEPT_IMPL(type, checks, uid) \
    class BOOST_PP_CAT(Checker, uid) final {\
        using Type = type;\
        BOOST_PP_SEQ_FOR_EACH(DOBBY_GEN_STATIC_ASSERT, type, checks)\
    };\
    static constexpr BOOST_PP_CAT(Checker, uid) BOOST_PP_CAT(checker, uid){};

#define DOBBY_CHECK_CONCEPT(type, checks)\
    DOBBY_CHECK_CONCEPT_IMPL(type, checks, __COUNTER__)
