#ifndef DOBERMAN_SRC_SYNC_DEREFERENCE_H_
#define DOBERMAN_SRC_SYNC_DEREFERENCE_H_

#include <memory>
#include <boost/optional.hpp>

namespace doberman {
namespace detail {
namespace impl {
template <typename T>
struct is_dereferencible_helper : std::is_pointer<T> {};

template <typename T>
struct is_dereferencible_helper<std::shared_ptr<T>> : std::true_type {};

template <typename T, typename Dtor>
struct is_dereferencible_helper<std::unique_ptr<T, Dtor>> : std::true_type {};

template <typename T>
struct is_dereferencible_helper<boost::optional<T>> : std::true_type {};

template <typename T>
struct is_dereferencible : is_dereferencible_helper<std::decay_t<T>> {};

template <typename T, typename = void>
struct dereference_impl;

template <typename T>
struct dereference_impl<T, std::enable_if_t<is_dereferencible<T>::value>> {
    template <typename Arg>
    constexpr static auto& call(Arg&& v) { return *v; }
};

template <typename T>
struct dereference_impl<T, std::enable_if_t<!is_dereferencible<T>::value>> {
    template <typename Arg>
    constexpr static auto& call(Arg&& v) { return v; }
};

template <typename T>
constexpr auto& dereference(T&& v) {
    return dereference_impl<T>::call(std::forward<T>(v));
}

} // namespace impl

template <typename T>
constexpr auto& dereference(T&& v) {
    using ::doberman::detail::impl::dereference;
    return dereference(std::forward<T>(v));
}

} // namespace detail
} // namespace doberman

#endif /* DOBERMAN_SRC_SYNC_DEREFERENCE_H_ */
