#pragma once

#include <memory>

namespace doberman {
namespace detail {

template <typename Fin>
auto finally(Fin&& fin) {
    auto f = [fin = std::forward<Fin>(fin)](void*) mutable { fin(); };
    return std::unique_ptr<void, decltype(f)> (std::addressof(f), std::move(f));
}

} // namespace detail
} // namespace doberman
