#ifndef DOBERMAN_SRC_CORO_GUARDED_H_
#define DOBERMAN_SRC_CORO_GUARDED_H_

#include <coroutine_mutex/coroutine_mutex.hpp>

namespace doberman {
namespace detail {

template<typename T, typename Mutex = ::coro::Mutex>
class Guarded {
    using LockHandle = typename Mutex::LockHandle;
    using YieldContext = typename Mutex::YieldContext;

    struct Unlocker {
        template <typename V>
        void operator() (V* ptr) const {
            if (ptr) {
                m_.unlock(h_);
            }
        }

        Mutex& m_;
        LockHandle h_;
    };
public:
    using Handle = std::unique_ptr<T, Unlocker>;
    using ConstHandle = std::unique_ptr<const T, Unlocker>;

    template<typename ... Args>
    Guarded(Args &&... args) : obj(std::forward<Args>(args)...) {}

    Handle lock(YieldContext yield) {
        return handle(mutex.lock(yield));
    }

    Handle tryLock(YieldContext yield) {
        return handle(mutex.try_lock(yield));
    }

    ConstHandle lock(YieldContext yield) const {
        return handle(mutex.lock(yield));
    }

    ConstHandle tryLock(YieldContext yield) const {
        return handle(mutex.try_lock(yield));
    }

private:
    Handle handle(LockHandle h) { return {h ? &obj : nullptr, {mutex, h}}; }
    ConstHandle handle(LockHandle h) const { return {h ? &obj : nullptr, {mutex, h}}; }

    T obj;
    mutable Mutex mutex;
};

} // namespace detail
} // namespace doberman

#endif /* DOBERMAN_SRC_CORO_GUARDED_H_ */
