#pragma once

#include <map>

namespace doberman {
namespace detail {

template <typename Ptr, typename Handler, int nRef>
class UseCountTracker {
public:
    auto operator -> () { return ptr_.get(); }
    auto operator -> () const { return ptr_.get(); }
    auto& operator * () { return *ptr_; }
    auto& operator * () const { return *ptr_; }

    ~UseCountTracker() {
        if (ptr_.use_count() == nRef) {
            handler_();
        }
    }
    UseCountTracker(Ptr ptr, Handler handler)
    : ptr_(std::move(ptr)), handler_(std::move(handler)) {}
private:
    Ptr ptr_;
    Handler handler_;
};

template <int nRef, typename Ptr, typename Deleter>
inline auto makeUseCountTracker(Ptr&& p, Deleter&& d) {
    return UseCountTracker<std::decay_t<Ptr>, std::decay_t<Deleter>, nRef>{
        std::forward<Ptr>(p), std::forward<Deleter>(d)
    };
}

template <typename Id, typename Ctor>
class MagicHat {
public:
    auto get(const Id& id) {
        auto i = map.find(id);
        if (i == map.end()) {
            i = map.emplace(id, ctor(id)).first;
        }

        return makeUseCountTracker<2>(i->second, [i, this]{ map.erase(i); });
    }
    MagicHat(Ctor ctor) : ctor(std::move(ctor)) {}
private:
    using Value = decltype(std::declval<Ctor>()(std::declval<Id>()));
    std::map<Id, Value> map;
    Ctor ctor;
};

} // namespace detail
} // namespace doberman
