#include <src/detail/type_name.h>

#ifdef __GNUG__
#include <cstdlib>
#include <memory>
#include <cxxabi.h>
#endif

namespace doberman {
namespace detail {

#ifdef __GNUG__

std::string demangle(const char* name) {

    int status = -4;

    std::unique_ptr<char, void(*)(void*)> res {
        abi::__cxa_demangle(name, NULL, NULL, &status),
        std::free
    };

    return (status==0) ? res.get() : name ;
}
#else

#error std::string demangle(const char* ) not implemented

#endif

} // namespace detail
} // namespace doberman
