#pragma once

#include <string>
#include <typeinfo>

namespace doberman {
namespace detail {

std::string demangle(const char* name);

template <class T>
inline std::string typeName() {
    return demangle(typeid(T).name());
}

template <class T>
inline std::string typeName(const T& v) {
    return demangle(typeid(v).name());
}

} // namespace detail
} // namespace doberman
