#pragma once

#include <logdog/logger.h>
#include <src/meta/types.h>
#include <macs_pg/macs_pg.h>

namespace doberman {
namespace log {

using namespace logdog;

LOGDOG_DEFINE_ATTRIBUTE(int64_t, change_id);
LOGDOG_DEFINE_ATTRIBUTE(Uid, uid);
LOGDOG_DEFINE_ATTRIBUTE(ThreadId, tid);
LOGDOG_DEFINE_ATTRIBUTE(Mid, mid);
LOGDOG_DEFINE_ATTRIBUTE(std::vector<std::string>, mids);
LOGDOG_DEFINE_ATTRIBUTE(SubscriptionState, subscription_state);
LOGDOG_DEFINE_ATTRIBUTE(SubscriptionId, subscription_id);
LOGDOG_DEFINE_ATTRIBUTE(Uid, subscriber_uid);
LOGDOG_DEFINE_ATTRIBUTE(Uid, owner_uid);
LOGDOG_DEFINE_ATTRIBUTE(Fid, owner_fid);
LOGDOG_DEFINE_ATTRIBUTE(LaunchId, launch_id);
LOGDOG_DEFINE_ATTRIBUTE(std::string, worker_id);
LOGDOG_DEFINE_ATTRIBUTE(std::string, shard_id);
LOGDOG_DEFINE_ATTRIBUTE(std::chrono::steady_clock::duration, worker_id_time);
LOGDOG_DEFINE_ATTRIBUTE(std::chrono::steady_clock::duration, worker_id_ttl);
LOGDOG_DEFINE_ATTRIBUTE(std::string, worker_id_state);
} // namespace log

using log::make_log;

} // namespace doberman

#define DOBBY_LOG_WITH_LEVEL(logger, level_name, ...) \
        ::doberman::log::level_name(logger, [&](auto __write) mutable {\
            __write(::doberman::log::message=__VA_ARGS__);\
        })

#define DOBBY_LOG_ERROR(logger, ...) DOBBY_LOG_WITH_LEVEL(logger, error, __VA_ARGS__)
#define DOBBY_LOG_WARNING(logger, ...) DOBBY_LOG_WITH_LEVEL(logger, warning, __VA_ARGS__)
#define DOBBY_LOG_NOTICE(logger, ...) DOBBY_LOG_WITH_LEVEL(logger, notice, __VA_ARGS__)
#define DOBBY_LOG_DEBUG(logger, ...) DOBBY_LOG_WITH_LEVEL(logger, debug, __VA_ARGS__)

#define STRING_LINE_I_(x) #x
#define STRING_LINE(x) STRING_LINE_I_(x)
#define DOBBY_WHERE ::std::make_tuple(\
        ::doberman::log::where_name=__FUNCTION__,\
        ::doberman::log::where_file=__FILE__,\
        ::doberman::log::where_line=STRING_LINE(__LINE__))

#define DOBBY_LOG_WITH_LEVEL_WHERE(logger, level_name, ...) \
        ::doberman::log::level_name(logger, [&, _w_ = DOBBY_WHERE](auto __write) mutable {\
            __write(::doberman::log::message=__VA_ARGS__, _w_);})

#define DOBBY_LOG_ERROR_WHERE(logger, ...) DOBBY_LOG_WITH_LEVEL_WHERE(logger, error, __VA_ARGS__)
#define DOBBY_LOG_WARNING_WHERE(logger, ...) DOBBY_LOG_WITH_LEVEL_WHERE(logger, warning, __VA_ARGS__)
#define DOBBY_LOG_NOTICE_WHERE(logger, ...) DOBBY_LOG_WITH_LEVEL_WHERE(logger, notice, __VA_ARGS__)
#define DOBBY_LOG_DEBUG_WHERE(logger, ...) DOBBY_LOG_WITH_LEVEL_WHERE(logger, debug, __VA_ARGS__)
