#ifndef DOBERMAN_SRC_LOGIC_ACCESS_H_
#define DOBERMAN_SRC_LOGIC_ACCESS_H_

#include <src/detail/dereference.h>

namespace doberman {
namespace logic {

template <typename Access, typename ... Args>
inline auto makeContext(Access&& acc, Args&& ... args) {
    return detail::dereference(acc).makeContext(std::forward<Args>(args)...);
}


template <typename ... Ts>
using AccessContext = decltype(makeContext(std::declval<Ts>()...));

} // namespace logic
} // namespace doberman

#endif /* DOBERMAN_SRC_LOGIC_ACCESS_H_ */
