#ifndef DOBERMAN_SRC_SYNC_AGENT_LAUNCHER_H_
#define DOBERMAN_SRC_SYNC_AGENT_LAUNCHER_H_

#include <src/logic/agent.h>
#include <src/logic/subscription_repository.h>
#include <src/detail/dereference.h>
#include <src/service_control/run_status.h>

namespace doberman {
namespace logic {

template <
    typename SubscriptionRepository,
    typename Spawner,
    typename Log,
    typename Profiler>
class AgentLauncher {
public:
    void run() {
        while (runStatus) {
            if (auto data = detail::dereference(repo).get()) {
                spawn([data = std::move(data), log = this->log, profiler = this->profiler,
                      runStatus = &(this->runStatus), labelFilter = this->labelFilter]
                      (auto access) mutable {
                    auto subscription = makeSubscription(
                            std::move(data),
                            detail::dereference(access).sharedFolder(),
                            detail::dereference(access).subscribedFolder(),
                            detail::dereference(access).changeQueue(),
                            detail::dereference(access).subscription(),
                            std::move(labelFilter));

                    auto agent = makeAgent(
                            std::move(subscription),
                            detail::dereference(access).envelopeCopier(),
                            ChangeFilter{},
                            log,
                            profiler,
                            *runStatus);

                    agent.run();
                });
            }
        }
    }

    AgentLauncher(SubscriptionRepository repo, Spawner spawn, Log log, Profiler profiler,
                  LabelFilter labelFilter, const service_control::RunStatus& runStatus)
    : repo(std::move(repo)), spawn(std::move(spawn)), log(std::move(log)), profiler(std::move(profiler)),
      labelFilter(std::move(labelFilter)), runStatus(runStatus) {}

private:
    SubscriptionRepository repo;
    Spawner spawn;
    Log log;
    Profiler profiler;
    LabelFilter labelFilter;
    const service_control::RunStatus& runStatus;
};

template <
    typename SubscriptionRepository,
    typename Spawner,
    typename Log,
    typename Profiler>
inline auto makeAgentLauncher(SubscriptionRepository repo, Spawner s, Log log, Profiler profiler,
                              LabelFilter labelFilter, const service_control::RunStatus& runStatus) {
    return AgentLauncher<SubscriptionRepository, Spawner, Log, Profiler> {
        std::move(repo), std::move(s), std::move(log), std::move(profiler), std::move(labelFilter), runStatus};
}

} // namespace logic
} // namespace doberman

#endif /* DOBERMAN_SRC_SYNC_AGENT_LAUNCHER_H_ */
