#ifndef DOBERMAN_SRC_SYNC_CHANGE_QUEUE_H_
#define DOBERMAN_SRC_SYNC_CHANGE_QUEUE_H_

#include <src/meta/types.h>
#include <src/logic/change.h>
#include <boost/optional.hpp>
#include <src/logic/access.h>

namespace doberman {
namespace logic {

template <typename Access>
class ChangeQueue {
public:
    std::shared_ptr<const Change> top() const {
        return detail::dereference(access_).top(actx_);
    }

    void pop() {
        detail::dereference(access_).pop(actx_);
    }

    auto& subscriptionId() const { return sid_;}

    ChangeQueue(SubscriptionId sid, Access acc)
    : sid_(sid), access_(std::move(acc)), actx_(makeContext(access_, subscriptionId())) {}

private:
    SubscriptionId sid_;
    Access access_;
    AccessContext<Access, SubscriptionId> actx_;
};

template <typename Access>
inline auto makeChangeQueue(SubscriptionId sid, Access acc) {
    return ChangeQueue<Access>(std::move(sid), std::move(acc));
}

} // namespace logic
} // namespace doberman


#endif /* DOBERMAN_SRC_SYNC_CHANGE_QUEUE_H_ */
