#pragma once

#include <src/logic/shared_folder.h>
#include <src/logic/subscribed_folder.h>
#include <src/meta/labels.h>

namespace doberman {
namespace logic {

struct TrivialEnvelopeCopier {
    template <typename T1, typename T2, typename Condition>
    void operator()(const SharedFolder<T1>& src, SubscribedFolder<T2>& dst,
                    Condition&& stopReading) const {
        for (auto& e : src.envelopesWithMimes(dst.lastSyncedImapId())) {
            if (stopReading()) {
                break;
            }
            dst.initPut(std::move(e), src.labels());
        }
    }
};

} // namespace logic
} // namespace doberman
