#pragma once

#include <mail_errors/error_code.h>
#include <string>

namespace doberman {
namespace logic {

enum class error {
    ok, // Resrved for no error at all
    logic, // Any logic error
};

} // namespace logic
} // namespace doberman

namespace boost {
namespace system {

template <>
struct is_error_condition_enum<doberman::logic::error> {
    static const bool value = true;
};

template <>
struct is_error_code_enum<doberman::logic::error> : std::true_type {};

} // namespace system
} // namespace boost

namespace doberman {
namespace logic {

using error_code = mail_errors::error_code;
using error_category = error_code::error_category;

class Category : public error_category {
public:
    const char* name() const noexcept override {
        return "doberman::logic::error";
    }

    std::string message(int v) const override {
        switch(error(v)) {
            case error::ok :
                return "no error";
            case error::logic :
                return "logic error";
        }
        return "unknown error";
    }
};

inline const error_category& category() {
    static Category instance;
    return instance;
}

inline error_code::base_type make_error_code(error e) {
    return error_code::base_type(static_cast<int>(e), category());
}

} // namespace logic
} // namespace doberman
