#ifndef DOBERMAN_SRC_SYNC_SHARED_FOLDER_H_
#define DOBERMAN_SRC_SYNC_SHARED_FOLDER_H_

#include <src/logic/types.h>
#include <src/logic/access.h>

namespace doberman {
namespace logic {

template <typename Access>
class SharedFolder {
    SharedFolderCoordinates coord_;
    Access access_;
    AccessContext<Access, SharedFolderCoordinates> actx_;
public:
    SharedFolder(SharedFolderCoordinates coord, Access access)
    : coord_(std::move(coord)), access_(std::move(access)),
      actx_(makeContext(access_, coord_)){}

    const Fid& fid() const { return coord_.fid; }
    const Uid& uid() const { return coord_.owner.uid; }

    Revision revision() const {
        return detail::dereference(access_).revision(actx_);
    }

    auto envelopesWithMimes(int64_t lowestImapId) const {
        return detail::dereference(access_).envelopesWithMimes(actx_, lowestImapId);
    }

    auto labels() const {
        return detail::dereference(access_).labels(actx_);
    }
};

template <typename Access>
inline auto makeSharedFolder(SharedFolderCoordinates coord, Access access) {
    return SharedFolder<Access>(std::move(coord), std::move(access));
}

} // namespace logic
} // namespace doberman

#endif /* DOBERMAN_SRC_SYNC_SHARED_FOLDER_H_ */
