#ifndef DOBERMAN_SRC_LOGIC_TYPES_H_
#define DOBERMAN_SRC_LOGIC_TYPES_H_

#include <src/meta/types.h>

namespace doberman {
namespace logic {

struct Owner {
    Uid uid;
};

struct Subscriber {
    Uid uid;
};

template <typename T>
constexpr bool isUser() {
    using Type = typename std::decay<T>::type;
    return std::is_same<Type, Owner>::value || std::is_same<Type, Subscriber>::value;
}

template <typename T>
inline typename std::enable_if<isUser<T>(), bool>::type operator == (const T& lhs, const T& rhs) {
    return lhs.uid == rhs.uid;
}

template <typename T>
inline typename std::enable_if<isUser<T>(), bool>::type operator != (const T& lhs, const T& rhs) {
    return !(lhs == rhs);
}

struct SharedFolderCoordinates {
    Owner owner;
    Fid fid;
};

inline bool operator == (const SharedFolderCoordinates& lhs, const SharedFolderCoordinates& rhs) {
    return lhs.owner == rhs.owner && lhs.fid == rhs.fid;
}

inline bool operator != (const SharedFolderCoordinates& lhs, const SharedFolderCoordinates& rhs) {
    return !(lhs == rhs);
}

struct SubscriptionData {
    SubscriptionId id;
    SharedFolderCoordinates folder;
    Subscriber subscriber;
};

inline bool operator == (const SubscriptionData& lhs, const SubscriptionData& rhs) {
    return lhs.id == rhs.id && lhs.folder == rhs.folder && lhs.subscriber == rhs.subscriber;
}

inline bool operator != (const SubscriptionData& lhs, const SubscriptionData& rhs) {
    return !(lhs == rhs);
}

} // namespace logic
} // namespace doberman

#endif /* DOBERMAN_SRC_LOGIC_TYPES_H_ */
