#ifndef DOBERMAN_SRC_PROFILING_LOG_H_
#define DOBERMAN_SRC_PROFILING_LOG_H_

#include <macs_pg/profiling.h>

namespace doberman {
namespace profiling {

using Log = macs::pg::profiling::Log;
using LogPtr = macs::pg::profiling::LogPtr;
using Time = macs::pg::Time;
using Duration = macs::pg::Duration;
using macs::pg::now;

inline auto duration(const Time& start, const Time& stop) {
    return Duration(stop.time_since_epoch() - start.time_since_epoch());
}

inline void write(const Log & log, const Time& from, const std::string& operation,
        const std::string& info ) {
    log.write( operation, info, duration(from, now()) );
}

inline auto checkpoint(const Log & log, const Time& from, const std::string& operation,
        const std::string& info ) {
    write(log, from, operation, info);
    return now();
}

} // namespace profiling
} // namespace doberman

#endif /* DOBERMAN_SRC_PROFILING_LOG_H_ */
