#ifndef DOBERMAN_SRC_PROFILING_PA_PROFILER_H_
#define DOBERMAN_SRC_PROFILING_PA_PROFILER_H_

#include <pa/async.h>
#include <src/profiling/profiler.h>

namespace doberman {
namespace profiling {
namespace pa {

class PaProfiler {
public:
    PaProfiler(const std::string& filename) {
        prof_.init(500000, 16, filename);
    }

    void write(const std::string& caller,
               const std::string& action,
               Duration duration) const {
        write(caller, action, "0", duration);
    }

    void write(const std::string& caller,
               const std::string& action,
               const std::string& info,
               Duration duration) const {
        prof_.add(::pa::doberman, caller, action, info,
                  static_cast<uint32_t>(Milliseconds(duration).count()));
    }

private:
    ::pa::async_profiler prof_;
};

inline auto makeProfilerImpl(const std::string& filename) {
    return PaProfiler(filename);
}

inline auto makeProfiler(const std::string& filename) {
    return doberman::profiling::makeProfiler(makeProfilerImpl(filename));
}

} // namespace pa
} // namespace profiling
} // namespace doberman

#endif // DOBERMAN_SRC_PROFILING_PA_PROFILER_H_
