#pragma once

#include <boost/optional.hpp>

namespace doberman {
namespace service_control {

enum class CommandType {
    stop,
    reopenLog,
    stat,
    invalid
};

using OptCommandType = boost::optional<CommandType>;

inline std::ostream& operator<< (std::ostream& stream, const CommandType commandType) {
    switch (commandType) {
        case CommandType::stop:
            stream << "stop";
            break;
        case CommandType::reopenLog:
            stream << "reopen log";
            break;
        case CommandType::stat:
            stream << "stat";
            break;
        case CommandType::invalid:
            stream << "invalid";
            break;
    }
    return stream;
}

inline std::ostream& operator<< (std::ostream& stream, const OptCommandType& commandType) {
    if (commandType) {
        stream << commandType.get();
    }
    return stream;
}

}}
