#pragma once

#include <atomic>

namespace doberman {
namespace service_control {

class RunStatus final {
public:
    operator bool() const noexcept {
        return running.load(std::memory_order_acquire);
    }

    void reset() noexcept {
        running.store(false, std::memory_order_release);
    }

private:
    std::atomic<bool> running{ true };
};

}}
