import json
from werkzeug.wrappers import Request, Response
from werkzeug.serving import run_simple

from mail.doberman.unistat.lib.unistat import make_all_stat

SELF_PORT = 8080


@Request.application
def handler(request):
    if request.method == 'GET' and request.path == '/stat':
        resp = Response(json.dumps(make_all_stat()))
        resp.headers['content-type'] = 'application/json'
    else:
        resp = Response()
        resp.status_code = 404
    return resp


def main():
    run_simple('::', SELF_PORT, handler)
