import subprocess

DOBERMAN_LOG_FILE = '/var/log/doberman/doberman.tskv'
MONITORING_PERIOD = 60
MONITORS = {
    'error': [
        {
            'name': 'logic',
            'field': 'error_code.category',
            'grep': 'doberman::logic::error',
        },
        {
            'name': 'apq',
            'field': 'error_code.category',
            'grep': 'apq.pq',
        },
        {
            'name': 'macs',
            'field': 'error_code.category',
            'grep': 'macs::error::Category',
        },
        {
            'name': 'pg_common',
            'field': 'error_code.category',
            'grep': 'pgg::error::CommonCategory',
        },
        {
            'name': 'pg_readonly',
            'field': 'error_code.category',
            'grep': 'pgg::error::ReadonlyCategory',
        },
        {
            'name': 'pg_connection',
            'field': 'error_code.category',
            'grep': 'pgg::error::ConnectionCategory',
        },
        {
            'name': 'pg_sql',
            'field': 'error_code.category',
            'grep': 'pgg::error::SqlCategory',
        },
        {
            'name': 'pg_database',
            'field': 'error_code.category',
            'grep': 'pgg::errc::DatabaseCategory',
        },
        {
            'name': 'pg_repository',
            'field': 'error_code.category',
            'grep': 'pgg::query::repository::error',
        },
        {
            'name': 'sharpei_client',
            'field': 'error_code.category',
            'grep': 'sharpei_client',
        },
    ],
    'notice': [
        {
            'name': 'ignore',
            'field': 'message',
            'grep': 'Ignore ',
        },
        {
            'name': 'retry',
            'field': 'message',
            'grep': 'Retry '
        },
    ]
}


def get_last_records(file, seconds):
    cmd = 'timetail -n ' + str(seconds) + ' -r unixtime=([0-9]+) ' + file
    p = subprocess.Popen(cmd.split(), stdout=subprocess.PIPE, stderr=open('/dev/null'))
    all_records = p.communicate()[0].decode().splitlines()
    return all_records


def parse_record(record):
    parsed = {}
    for item in record.split('\t'):
        key_value = item.split('=', 1)
        parsed[key_value[0]] = key_value[1] if len(key_value) > 1 else None
    return parsed


def get_stat_name(record, values, default=None):
    for v in values:
        msg = record.get(v['field'])
        if msg and v['grep'] in msg:
            return v['name']
    return default


def get_stat_by_records(all_records, monitors):
    stat = {}
    for level, vals in monitors.items():
        stat[level] = dict.fromkeys([v['name'] for v in vals], 0)
    stat['error']['unexpected'] = 0

    for r in all_records:
        record = parse_record(r)
        record_level = record.get('level')
        try:
            vals = monitors[record_level]
        except KeyError:
            continue

        name = get_stat_name(record, vals, 'unexpected')
        if name in stat[record_level]:
            stat[record_level][name] += 1

    return stat


def get_stat(period=MONITORING_PERIOD):
    all_records = get_last_records(DOBERMAN_LOG_FILE, period)
    return get_stat_by_records(all_records, MONITORS)
