import subprocess
import sys

PROFILER_LOG_FILE = '/var/log/doberman/profiler.log'
MONITORING_PERIOD = 60

OPERATIONS = [
    'init_subscribe_copy',
    'change_apply_put',
    'change_apply_move',
    'change_apply_remove',
    'change_apply_erase',
    'change_apply_update',
    'change_apply_join_threads',
    'change_cache_fetch',
    'change_log_cache_fetch',
    'query_init_store',
    'query_fetch_envelopes',
    'query_clear',
    'unsubscribe_clear',
]


def get_last_records(file, seconds):
    cmd = 'pa -t ' + str(seconds) + ' ' + file
    p = subprocess.Popen(cmd.split(), stdout=subprocess.PIPE, stderr=open('/dev/null'))
    all_records = p.communicate()[0].decode().splitlines()
    return all_records


def parse_record(raw_rec):
    parsed = {}
    record = raw_rec.split()
    parsed['sender'] = record[1]
    parsed['operation'] = (record[2] + '_' + record[3]).lower().replace(' ', '_')
    try:
        time = int(float(record[-1]) * 1000)
    except:
        time = 0
    parsed['time'] = time
    return parsed


def set_times(record, times):
    times['max'] = max(record['time'], times['max'])
    times['min'] = min(record['time'], times['min'])
    times['avg'] += record['time']


def get_stat_by_records(all_records, operations):
    counts = {}
    times = {}
    for op in operations:
        counts[op] = 0
        times[op] = {
            'min': sys.maxsize,
            'avg': 0,
            'max': 0,
        }

    for record in all_records:
        record_operation = record['operation']
        if record_operation in counts:
            counts[record_operation] += 1

        if record_operation in times:
            set_times(record, times[record_operation])

    for op in operations:
        if counts[op] == 0:
            times[op]['max'] = times[op]['min'] = times[op]['avg'] = 0
        else:
            times[op]['avg'] /= counts[op]
    return counts, times


def get_stat(period=MONITORING_PERIOD):
    all_records = get_last_records(PROFILER_LOG_FILE, period)
    all_parsed_records = (parse_record(r) for r in all_records)
    doberman_records = (r for r in all_parsed_records if r.get('sender') == 'doberman')
    return get_stat_by_records(doberman_records, OPERATIONS)
