import requests
import yaml

DOBERMAN_CONF = '/etc/doberman/doberman.yml'


def get_sharpei_host(file_name):
    with open(file_name) as f:
        conf = yaml.load(f)
        try:
            host = conf['sharpei']['host']
            port = conf['sharpei']['port']
        except KeyError:
            host = port = None
    return host, port


def get_sharpei_stat():
    host, port = get_sharpei_host(DOBERMAN_CONF)
    if host and port:
        try:
            resp = requests.get('http://' + host + ':' + str(port) + '/v3/stat', timeout=(0.1, 1))
        except IOError:
            return {}
        if resp.status_code == 200:
            return resp.json()
    return {}


def get_shard_name(shard_id, stat=None):
    res = shard_id
    try:
        if not stat:
            stat = get_sharpei_stat()
        res = stat[shard_id]['name']
    finally:
        return res
