import socket
import json

DOBERMAN_HOST = 'localhost'
DOBERMAN_PORT = 34088
DOBERMAN_CONN = (DOBERMAN_HOST, DOBERMAN_PORT)

UNKNOWN_SHARD = 'unknown_shard'
UNKNOWN_WORKER = 'unknown_worker'


def get_doberman_raw_stat():
    try:
        sock = socket.create_connection(DOBERMAN_CONN, 0.5)
        sock.sendall(b'stat\n')
        response = sock.recv(65536)
        sock.close()
        res = json.loads(response)
    except:
        res = {}
    return res


def get_job_info(raw_stat=None):
    try:
        if not raw_stat:
            raw_stat = get_doberman_raw_stat()
        worker_id = raw_stat.get('job', {}).get('worker_id', '')
        shard_id = raw_stat.get('job', {}).get('shard_id', '')
    except:
        worker_id = ''
        shard_id = ''
    return {
        'worker_id': worker_id if worker_id != '' else UNKNOWN_WORKER,
        'shard_id': shard_id if shard_id != '' else UNKNOWN_SHARD
    }


def is_alive(job_info):
    return job_info.get('worker_id', UNKNOWN_WORKER) != UNKNOWN_WORKER and \
        job_info.get('shard_id', UNKNOWN_SHARD) != UNKNOWN_SHARD
