from .log import get_stat as get_log
from .pa import get_stat as get_pa
from .stat import get_job_info, is_alive
from .sharpei import get_shard_name

MONITORING_PERIOD = 5


def get_prefix(worker, shard):
    return 'ctype={};tier={}'.format(shard.replace('_', ''), worker.replace('_', ''))


def make_log_stat(prefix, stat):
    res = []
    for l, s in stat.items():
        res += [
            ['{};{}_{}_ammm'.format(prefix, k, l), v]
            for k, v in s.items()
        ]
    return res


def make_pa_stat(prefix, stat):
    counts, times = stat
    res = [
        ['{};{}_count_ammm'.format(prefix, k), v]
        for k, v in counts.items()
    ]
    for k, v in times.items():
        res += [['{};{}_time_max_axxx'.format(prefix, k), v['max']]]
        res += [['{};{}_time_min_annn'.format(prefix, k), v['min']]]
        res += [['{};{}_time_avg_avvv'.format(prefix, k), v['avg']]]
    return res


def make_alive_stat(job_info):
    return [['is_alive_worker_ammm', int(is_alive(job_info))]]


def make_all_stat():
    job_info = get_job_info()
    prefix = get_prefix(job_info['worker_id'], get_shard_name(job_info['shard_id']))

    res = make_alive_stat(job_info) + \
        make_log_stat(prefix, get_log(MONITORING_PERIOD)) + \
        make_pa_stat(prefix, get_pa(MONITORING_PERIOD))
    return res
