#!/bin/bash

CFG_DIR="/etc/push-client/"

configs=$(find $CFG_DIR -maxdepth 1 -type f -o -type l)

pidof push-client && kill -9 $(pidof push-client)

for cnf in $configs; do
    sleep 5
    echo "Config found: "$cnf >> /tmp/out
    /usr/bin/push-client -f -c $cnf &
done

sleep 5

while [ True ]; do
    pid_state=$(pidof push-client)
    sleep 30
    if [ "$pid_state" != "$(pidof push-client)" ];then
        echo "Some PID missed, exit!"
        exit 1
    fi
done


