#!/bin/bash

# Проверка наличия смонитрованого эфимерного диска:
function check_ephemeral() {
    mount | grep -q "/ephemeral"
}

# Симлинки каталогов с логами в эфимерный диск:
function qloud_log {
# Usage: qloud_logs foldername [user:group]
    if [ -z $1 ];then
        echo "Directory missing!"
        return 1
    fi
    rm -rf "/var/log/$1"
    mkdir -pv "/ephemeral/log/$1" || true
    ln -sfv "/ephemeral/log/$1" /var/log/
    ([[ $2 ]] && chown -Rv $2 /ephemeral/log/$1) || true

}

# Симлинки произвольных каталогов:
# Пример:
# qloud_link /var/log/app создаст:
# /var/log/app -> /ephemeral/var/log/app
function qloud_link {
# Usage: qloud_link dir($1) [user:group]($2)
    local sdir=$(echo $1 | sed 's/\/$//')
    file -i $sdir | grep -q "symlink"
    if [ $? -ne 0 ]; then
        rm -rf $sdir
        mkdir -pv "/ephemeral$sdir" || true
        ln -sfv "/ephemeral$sdir" $(dirname $sdir)
        ([[ $2 ]] && chown -Rv $2 /ephemeral$sdir) || true
    else
        echo "Symlink already exists: "$sdir
    fi
}

function push_client_link {
    ln -svf /etc/supervisor/conf-available/push-client.conf /etc/supervisor/conf.d/
}
