#!/usr/bin/env bash

LOG_DIR="/var/log/yasmagent/"

if [ ! -d "$LOG_DIR" ];then
    exit 0
fi

for _ in {1..3}; do
    YASM_PID=$(pgrep -f /usr/local/yasmagent/python/bin/python)
    echo $YASM_PID
    if [ "$YASM_PID" == "" ];then
        (supervisorctl avail | grep -q  yasmagent) && supervisorctl restart yasmagent
        (portoctl list 2>/dev/null | grep -q yasmagent) && portoctl restart app/sub_yasmagent
    else
        flock -xn /var/tmp/yasmagent.lock \
            -c "curl -s 'http://localhost:11003/json/' > /dev/null 2>&1 || kill -9 $YASM_PID"
    fi
done;
